/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt;

import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.ActionAuthorization;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.actions.Action;
import com.floragunn.searchguard.authz.actions.ActionRequestIntrospector;
import com.floragunn.searchguard.authz.actions.Actions;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfig;
import com.floragunn.searchguard.privileges.PrivilegesInterceptor;
import com.floragunn.searchguard.user.User;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.action.termvectors.MultiTermVectorsRequest;
import org.elasticsearch.action.termvectors.TermVectorsRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.rest.RestStatus;

public class PrivilegesInterceptorImpl
implements PrivilegesInterceptor {
    private static final String USER_TENANT = "__user__";
    private final Action KIBANA_ALL_SAVED_OBJECTS_WRITE;
    private final Action KIBANA_ALL_SAVED_OBJECTS_READ;
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final String kibanaServerUsername;
    private final String kibanaIndexName;
    private final String kibanaIndexNamePrefix;
    private final Pattern versionedKibanaIndexPattern;
    private final Pattern kibanaIndexPatternWithTenant;
    private final ImmutableSet<String> tenantNames;
    private final boolean enabled;

    public PrivilegesInterceptorImpl(FeMultiTenancyConfig config, ImmutableSet<String> tenantNames, Actions actions) {
        this.enabled = config.isEnabled();
        this.kibanaServerUsername = config.getServerUsername();
        this.kibanaIndexName = config.getIndex();
        this.kibanaIndexNamePrefix = this.kibanaIndexName + "_";
        this.versionedKibanaIndexPattern = Pattern.compile(Pattern.quote(this.kibanaIndexName) + "(_-?[0-9]+_[a-z0-9]+)?(_[0-9]+\\.[0-9]+\\.[0-9]+(_[0-9]{3})?)");
        this.kibanaIndexPatternWithTenant = Pattern.compile(Pattern.quote(this.kibanaIndexName) + "(_-?[0-9]+_[a-z0-9]+(_[0-9]{3})?)");
        this.tenantNames = tenantNames.with((Object)"SGS_GLOBAL_TENANT");
        this.KIBANA_ALL_SAVED_OBJECTS_WRITE = actions.get("kibana:saved_objects/_/write");
        this.KIBANA_ALL_SAVED_OBJECTS_READ = actions.get("kibana:saved_objects/_/read");
    }

    private boolean isTenantAllowed(PrivilegesEvaluationContext context, ActionRequest request, Action action, String requestedTenant, ActionAuthorization actionAuthorization) throws PrivilegesEvaluationException {
        if (!this.isTenantValid(requestedTenant)) {
            this.log.warn("Invalid tenant: " + requestedTenant + "; user: " + context.getUser());
            return false;
        }
        if (requestedTenant.equals(USER_TENANT)) {
            return true;
        }
        boolean hasReadPermission = actionAuthorization.hasTenantPermission(context, this.KIBANA_ALL_SAVED_OBJECTS_READ, requestedTenant).isOk();
        boolean hasWritePermission = actionAuthorization.hasTenantPermission(context, this.KIBANA_ALL_SAVED_OBJECTS_WRITE, requestedTenant).isOk();
        if (!(hasReadPermission |= hasWritePermission)) {
            this.log.warn("Tenant {} is not allowed for user {}", (Object)requestedTenant, (Object)context.getUser().getName());
            return false;
        }
        if (!hasWritePermission && action.name().startsWith("indices:data/write")) {
            this.log.warn("Tenant {} is not allowed to write (user: {})", (Object)requestedTenant, (Object)context.getUser().getName());
            return false;
        }
        return true;
    }

    public PrivilegesInterceptor.InterceptionResult replaceKibanaIndex(PrivilegesEvaluationContext context, ActionRequest request, Action action, ActionAuthorization actionAuthorization) throws PrivilegesEvaluationException {
        String requestedTenant;
        IndexInfo kibanaIndexInfo;
        if (!this.enabled) {
            return PrivilegesInterceptor.InterceptionResult.NORMAL;
        }
        User user = context.getUser();
        ActionRequestIntrospector.ResolvedIndices requestedResolved = context.getRequestInfo().getResolvedIndices();
        if (user.getName().equals(this.kibanaServerUsername)) {
            return PrivilegesInterceptor.InterceptionResult.NORMAL;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("replaceKibanaIndex(" + action + ", " + user + ")\nrequestedResolved: " + requestedResolved + "\nrequestedTenant: " + user.getRequestedTenant());
        }
        if ((kibanaIndexInfo = this.checkForExclusivelyUsedKibanaIndexOrAlias(request, requestedResolved)) == null) {
            return PrivilegesInterceptor.InterceptionResult.NORMAL;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("IndexInfo: " + kibanaIndexInfo);
        }
        if ((requestedTenant = user.getRequestedTenant()) == null || requestedTenant.length() == 0 || requestedTenant.equals("SGS_GLOBAL_TENANT")) {
            if (kibanaIndexInfo.tenantInfoPart != null) {
                return PrivilegesInterceptor.InterceptionResult.NORMAL;
            }
            if (this.isTenantAllowed(context, request, action, "SGS_GLOBAL_TENANT", actionAuthorization)) {
                return PrivilegesInterceptor.InterceptionResult.NORMAL;
            }
            return PrivilegesInterceptor.InterceptionResult.DENY;
        }
        if (this.isTenantAllowed(context, request, action, requestedTenant, actionAuthorization)) {
            if (kibanaIndexInfo.isReplacementNeeded()) {
                this.replaceIndex(request, kibanaIndexInfo.originalName, kibanaIndexInfo.toInternalIndexName(user), action, user);
            }
            return PrivilegesInterceptor.InterceptionResult.ALLOW;
        }
        return PrivilegesInterceptor.InterceptionResult.DENY;
    }

    private void replaceIndex(ActionRequest request, String oldIndexName, String newIndexName, Action action, User user) {
        boolean kibOk = false;
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} index will be replaced with {} in this {} request", (Object)oldIndexName, (Object)newIndexName, (Object)request.getClass().getName());
        }
        if (request instanceof GetFieldMappingsIndexRequest || request instanceof GetFieldMappingsRequest) {
            return;
        }
        String[] newIndexNames = new String[]{newIndexName};
        if (request instanceof CreateIndexRequest) {
            ((CreateIndexRequest)request).index(newIndexName);
            kibOk = true;
        } else if (request instanceof BulkRequest) {
            for (DocWriteRequest ar : ((BulkRequest)request).requests()) {
                if (ar instanceof DeleteRequest) {
                    ((DeleteRequest)ar).index(newIndexName);
                }
                if (ar instanceof IndexRequest) {
                    ((IndexRequest)ar).index(newIndexName);
                }
                if (!(ar instanceof UpdateRequest)) continue;
                ((UpdateRequest)ar).index(newIndexName);
            }
            kibOk = true;
        } else if (request instanceof MultiGetRequest) {
            for (MultiGetRequest.Item item : ((MultiGetRequest)request).getItems()) {
                item.index(newIndexName);
            }
            kibOk = true;
        } else if (request instanceof MultiSearchRequest) {
            for (SearchRequest ar : ((MultiSearchRequest)request).requests()) {
                ar.indices(newIndexNames);
            }
            kibOk = true;
        } else if (request instanceof MultiTermVectorsRequest) {
            for (TermVectorsRequest ar : () -> ((MultiTermVectorsRequest)request).iterator()) {
                ar.index(newIndexName);
            }
            kibOk = true;
        } else if (request instanceof UpdateRequest) {
            ((UpdateRequest)request).index(newIndexName);
            kibOk = true;
        } else if (request instanceof IndexRequest) {
            ((IndexRequest)request).index(newIndexName);
            kibOk = true;
        } else if (request instanceof DeleteRequest) {
            ((DeleteRequest)request).index(newIndexName);
            kibOk = true;
        } else if (request instanceof SingleShardRequest) {
            ((SingleShardRequest)request).index(newIndexName);
            kibOk = true;
        } else if (request instanceof RefreshRequest) {
            ((RefreshRequest)request).indices(newIndexNames);
            kibOk = true;
        } else if (request instanceof ReplicationRequest) {
            ((ReplicationRequest)request).index(newIndexName);
            kibOk = true;
        } else if (request instanceof IndicesRequest.Replaceable) {
            IndicesRequest.Replaceable replaceableRequest = (IndicesRequest.Replaceable)request;
            replaceableRequest.indices(newIndexNames);
            kibOk = true;
        } else if (request instanceof IndicesAliasesRequest) {
            IndicesAliasesRequest indicesAliasesRequest = (IndicesAliasesRequest)request;
            for (IndicesAliasesRequest.AliasActions aliasActions : indicesAliasesRequest.getAliasActions()) {
                if (aliasActions.indices() == null || aliasActions.indices().length != 1) {
                    this.log.warn("Unexpected AliasActions: " + aliasActions);
                    continue;
                }
                if (!aliasActions.indices()[0].equals(oldIndexName)) {
                    this.log.warn("Unexpected AliasActions: " + aliasActions + "; expected index: " + oldIndexName);
                    continue;
                }
                aliasActions.index(newIndexName);
                if (aliasActions.actionType() != IndicesAliasesRequest.AliasActions.Type.REMOVE_INDEX) {
                    if (aliasActions.aliases() == null) {
                        this.log.warn("Unexpected AliasActions: " + aliasActions);
                        continue;
                    }
                    String[] aliases = aliasActions.aliases();
                    String[] newAliases = new String[aliases.length];
                    for (int i = 0; i < aliases.length; ++i) {
                        IndexInfo indexInfo = this.checkForExclusivelyUsedKibanaIndexOrAlias(aliases[i]);
                        newAliases[i] = indexInfo != null && indexInfo.isReplacementNeeded() ? indexInfo.toInternalIndexName(user) : aliases[i];
                    }
                    aliasActions.aliases(newAliases);
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Rewritten IndicesAliasesRequest: " + indicesAliasesRequest.getAliasActions());
            }
            kibOk = true;
        } else {
            this.log.warn("Dont know what to do (1) with {}", request.getClass());
        }
        if (!kibOk) {
            this.log.warn("Dont know what to do (2) with {}", request.getClass());
        }
    }

    private IndexInfo checkForExclusivelyUsedKibanaIndexOrAlias(ActionRequest request, ActionRequestIntrospector.ResolvedIndices requestedResolved) {
        if (requestedResolved.isLocalAll()) {
            return null;
        }
        Set<String> indices = this.getIndices(request);
        if (indices.size() == 1) {
            return this.checkForExclusivelyUsedKibanaIndexOrAlias(indices.iterator().next());
        }
        return null;
    }

    private IndexInfo checkForExclusivelyUsedKibanaIndexOrAlias(String aliasOrIndex) {
        if (aliasOrIndex.equals(this.kibanaIndexName)) {
            return new IndexInfo(aliasOrIndex, this.kibanaIndexName, null);
        }
        if (aliasOrIndex.startsWith(this.kibanaIndexNamePrefix)) {
            Matcher matcher = this.versionedKibanaIndexPattern.matcher(aliasOrIndex);
            if (matcher.matches()) {
                if (matcher.group(1) == null) {
                    return new IndexInfo(aliasOrIndex, this.kibanaIndexName, matcher.group(2));
                }
                return new IndexInfo(aliasOrIndex, this.kibanaIndexName, matcher.group(2), matcher.group(1));
            }
            matcher = this.kibanaIndexPatternWithTenant.matcher(aliasOrIndex);
            if (matcher.matches()) {
                return new IndexInfo(aliasOrIndex, this.kibanaIndexName, null, matcher.group(1));
            }
        }
        return null;
    }

    private Set<String> getIndices(ActionRequest request) {
        if (request instanceof PutMappingRequest) {
            PutMappingRequest putMappingRequest = (PutMappingRequest)request;
            return ImmutableSet.of((Object)(putMappingRequest.getConcreteIndex() != null ? putMappingRequest.getConcreteIndex().getName() : null), (Object[])putMappingRequest.indices());
        }
        if (request instanceof IndicesRequest) {
            if (((IndicesRequest)request).indices() != null) {
                return ImmutableSet.of(Arrays.asList(((IndicesRequest)request).indices()));
            }
            return Collections.emptySet();
        }
        if (request instanceof BulkRequest) {
            return ((BulkRequest)request).getIndices();
        }
        if (request instanceof MultiGetRequest) {
            return ((MultiGetRequest)request).getItems().stream().map(item -> item.index()).collect(Collectors.toSet());
        }
        if (request instanceof MultiSearchRequest) {
            return ((MultiSearchRequest)request).requests().stream().flatMap(r -> Arrays.stream(r.indices())).collect(Collectors.toSet());
        }
        if (request instanceof MultiTermVectorsRequest) {
            return ((MultiTermVectorsRequest)request).getRequests().stream().flatMap(r -> Arrays.stream(r.indices())).collect(Collectors.toSet());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Not supported for multi tenancy: " + request);
        }
        return Collections.emptySet();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getKibanaIndex() {
        return this.kibanaIndexName;
    }

    public String getKibanaServerUser() {
        return this.kibanaServerUsername;
    }

    public Map<String, Boolean> mapTenants(User user, ImmutableSet<String> roles, ActionAuthorization actionAuthorization) {
        if (user == null) {
            return ImmutableMap.empty();
        }
        ImmutableMap.Builder result = new ImmutableMap.Builder(roles.size());
        result.put((Object)user.getName(), (Object)true);
        PrivilegesEvaluationContext context = new PrivilegesEvaluationContext(user, roles, null, null, false, null, null);
        for (String tenant : this.tenantNames) {
            try {
                boolean hasReadPermission = actionAuthorization.hasTenantPermission(context, this.KIBANA_ALL_SAVED_OBJECTS_READ, tenant).isOk();
                boolean hasWritePermission = actionAuthorization.hasTenantPermission(context, this.KIBANA_ALL_SAVED_OBJECTS_WRITE, tenant).isOk();
                if (hasWritePermission) {
                    result.put((Object)tenant, (Object)true);
                    continue;
                }
                if (!hasReadPermission) continue;
                result.put((Object)tenant, (Object)false);
            }
            catch (PrivilegesEvaluationException e) {
                this.log.error("Error while evaluating privileges for " + user + " " + tenant, (Throwable)e);
            }
        }
        return result.build();
    }

    private boolean isTenantValid(String tenant) {
        return USER_TENANT.equals(tenant) || this.tenantNames.contains((Object)tenant);
    }

    private class IndexInfo {
        final String originalName;
        final String prefix;
        final String suffix;
        final String tenantInfoPart;

        IndexInfo(String originalName, String prefix, String suffix) {
            this.originalName = originalName;
            this.prefix = prefix;
            this.suffix = suffix;
            this.tenantInfoPart = null;
        }

        IndexInfo(String originalName, String prefix, String suffix, String tenantInfoPart) {
            this.originalName = originalName;
            this.prefix = prefix;
            this.suffix = suffix;
            this.tenantInfoPart = tenantInfoPart;
        }

        String toInternalIndexName(User user) {
            if (PrivilegesInterceptorImpl.USER_TENANT.equals(user.getRequestedTenant())) {
                return this.toInternalIndexName(user.getName());
            }
            return this.toInternalIndexName(user.getRequestedTenant());
        }

        boolean isReplacementNeeded() {
            return this.tenantInfoPart == null;
        }

        private String toInternalIndexName(String tenant) {
            if (tenant == null) {
                throw new ElasticsearchException("tenant must not be null here", new Object[0]);
            }
            String tenantInfoPart = "_" + tenant.hashCode() + "_" + tenant.toLowerCase().replaceAll("[^a-z0-9]+", "");
            if (this.tenantInfoPart != null && !this.tenantInfoPart.equals(tenantInfoPart)) {
                throw new ElasticsearchSecurityException("This combination of sgtenant header and index is not allowed.\nTenant: " + tenant + "\nIndex: " + this.originalName, RestStatus.BAD_REQUEST, new Object[0]);
            }
            StringBuilder result = new StringBuilder(this.prefix).append(tenantInfoPart);
            if (this.suffix != null) {
                result.append(this.suffix);
            }
            return result.toString();
        }

        public String toString() {
            return "IndexInfo [originalName=" + this.originalName + ", prefix=" + this.prefix + ", suffix=" + this.suffix + ", tenantInfoPart=" + this.tenantInfoPart + "]";
        }
    }
}

